//*******************************************************************************
//This program connects to the instrument and sends and receives commands.
//Enter the command and click the [Transmit and Receive] button to send it.
//If the command has a response (command contains "?"), the response is displayed in the editbox.
//
//System requirements (software)
//	Microsoft Visual Studio Professional 2017
//	Microsoft Visual C++ 2017
//*******************************************************************************

// SampleDlg.cpp : implementation file
//

#include "pch.h"
#include "framework.h"
#include "Sample.h"
#include "SampleDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSampleDlg dialog



CSampleDlg::CSampleDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SAMPLE_DIALOG, pParent)
	, m_strEdit1(_T(""))
	, m_dwEdit2(0)
	, m_strEdit3(_T(""))
	, m_dwEdit4(0)
	, m_strEdit5(_T(""))
	, m_Rs232cUsb()
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON1, m_Button1);
	DDX_Control(pDX, IDC_BUTTON2, m_Button2);
	DDX_Control(pDX, IDC_BUTTON3, m_Button3);
	DDX_Control(pDX, IDC_EDIT1, m_Edit1);
	DDX_Control(pDX, IDC_EDIT2, m_Edit2);
	DDX_Control(pDX, IDC_EDIT3, m_Edit3);
	DDX_Control(pDX, IDC_EDIT4, m_Edit4);
	DDX_Control(pDX, IDC_EDIT5, m_Edit5);
	DDX_Text(pDX, IDC_EDIT1, m_strEdit1);
	DDX_Text(pDX, IDC_EDIT2, m_dwEdit2);
	DDX_Text(pDX, IDC_EDIT3, m_strEdit3);
	DDX_Text(pDX, IDC_EDIT4, m_dwEdit4);
	DDX_Text(pDX, IDC_EDIT5, m_strEdit5);
}

BEGIN_MESSAGE_MAP(CSampleDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CSampleDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CSampleDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CSampleDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CSampleDlg::OnBnClickedButton4)
END_MESSAGE_MAP()


// CSampleDlg message handlers

// Process for dialog open
BOOL CSampleDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Initialize member variables
	m_strEdit1 = "COM1";
	m_dwEdit2 = 9600;
	m_strEdit3 = "*IDN?";
	m_dwEdit4 = 1;
	m_strEdit5 = "";
	UpdateData(FALSE);

	// Process for Enable/Disable on the buttons and editboxes
	m_Button1.EnableWindow(TRUE);
	m_Button2.EnableWindow(FALSE);
	m_Button3.EnableWindow(FALSE);
	m_Edit1.EnableWindow(TRUE);
	m_Edit2.EnableWindow(TRUE);
	m_Edit3.EnableWindow(FALSE);
	m_Edit4.EnableWindow(FALSE);
	m_Edit5.SetReadOnly(TRUE);
	m_Edit5.SetLimitText(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// Don't close dialog when hitting enter key
void CSampleDlg::OnOK()
{
}

void CSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

// Events when "Connect" button is clicked
void CSampleDlg::OnBnClickedButton1()
{
	UpdateData(TRUE);

	// Connect
	if (m_Rs232cUsb.OpenInterface(m_strEdit1, m_dwEdit2) != TRUE) {
		return;
	}

	// Process for Enable/Disable on the buttons and editboxes
	m_Button1.EnableWindow(FALSE);
	m_Button2.EnableWindow(TRUE);
	m_Button3.EnableWindow(TRUE);
	m_Edit1.EnableWindow(FALSE);
	m_Edit2.EnableWindow(FALSE);
	m_Edit3.EnableWindow(TRUE);
	m_Edit4.EnableWindow(TRUE);
}

// Events when "Disconnect" button is clicked
void CSampleDlg::OnBnClickedButton2()
{
	// Disconnect
	m_Rs232cUsb.CloseInterface();

	// Process for Enable/Disable on the buttons and editboxes
	m_Button1.EnableWindow(TRUE);
	m_Button2.EnableWindow(FALSE);
	m_Button3.EnableWindow(FALSE);
	m_Edit1.EnableWindow(TRUE);
	m_Edit2.EnableWindow(TRUE);
	m_Edit3.EnableWindow(FALSE);
	m_Edit4.EnableWindow(FALSE);
}

// Events when "Transmit and Receive" button is clicked
void CSampleDlg::OnBnClickedButton3()
{
	m_Edit3.EnableWindow(FALSE);

	UpdateData(TRUE);
	m_strEdit5 += _T("<< ") + m_strEdit3 + _T("\r\n");									// Output logs of transmitting data
	UpdateData(FALSE);
	m_Rs232cUsb.SendQueryMsg(m_strEdit3, m_dwEdit4 * 1000);								// Transmit and receive commands
	if (m_strEdit3.Find(_T("?")) != -1) {												// If the command contains "?"
		m_strEdit5 += _T(">> ") + m_Rs232cUsb.m_ReceiveData + _T("\r\n");				// Output logs of receiving data
		UpdateData(FALSE);
	}

	m_Edit3.EnableWindow(TRUE);
}

// Events when "Clear" button is clicked
void CSampleDlg::OnBnClickedButton4()
{
	// Clear the editbox
	UpdateData(TRUE);
	m_strEdit5 = _T("");
	UpdateData(FALSE);
}
